<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <title>Split Landing Page</title>
  <link rel="stylesheet" href="style.css">
  <style>
   .center-logo {
  position: absolute;
  top: 50%;
  left: 50%;
  transform: translate(-50%, -50%);
  z-index: 5;
  text-align: center;
  pointer-events: none;
}

.center-logo img {
  max-width: 150px;
  height: auto;
  opacity: 0.85;
}



    :root {
  --container-bg-color: #333;
  --left-bg-color: rgba(223, 39, 39, 0.7);
  --left-button-hover-color: rgba(161, 11, 11, 0.3);
  --right-bg-color: rgba(43, 43, 43, 0.8);
  --right-button-hover-color: rgba(92, 92, 92, 0.3);
  --hover-width: 75%;
  --other-width: 25%;
  --speed: 1000ms;
}

html,
body {
  padding: 0;
  margin: 0;
  font-family: "franklin gothic medium", "arial narrow", arial, sans-serif;
  width: 100%;
  height: 100%;
  overflow-x: hidden;
}

h1 {
  font-size: 4rem;
  color: #fff;
  position: absolute;
  left: 50%;
  top: 20%;
  transform: translateX(-50%);
  white-space: nowrap;
}

.button {
  display: block;
  position: absolute;
  left: 50%;
  top: 40%;
  height: 2.5rem;
  padding-top: 1.3rem;
  width: 15rem;
  text-align: center;
  color: #fff;
  border: #fff solid 0.2rem;
  font-size: 1rem;
  font-weight: bold;
  text-transform: uppercase;
  text-decoration: none;
  transform: translateX(-50%);
}

.split.left .button:hover {
  background-color: var(--left-button-hover-color);
  border-color: var(--left-button-hover-color);
}

.split.right .button:hover {
  background-color: var(--right-button-hover-color);
  border-color: var(--right-button-hover-color);
}

.container {
  position: relative;
  width: 100%;
  height: 100%;
  background: var(--container-bg-color);
}

.split {
  position: absolute;
  width: 50%;
  height: 100%;
  overflow: hidden;
}

.split.left {
  left: 0;
  background:#050505;
  /* background: url(img/designer.png) center center no-repeat; */
  background-size: cover;
}

.split.left:before {
  position: absolute;
  content: "";
  width: 100%;
  height: 100%;
  /* background: var(--left-bg-color); */
}

.split.right {
  right: 0;
  background:#f8e93b;
  /* background: url("img/programmer.jpeg") center center no-repeat; */
  background-size: cover;
}

.split.right:before {
  position: absolute;
  content: "";
  width: 100%;
  height: 100%;
  /* background: var(--right-bg-color); */
}

.split.left,
.split.right,
.split.left:before,
.split.right:before {
  transition: var(--speed) all ease-in-out;
}

.hover-left .split.left {
  width: var(--hover-width);
}

.hover-left .split.right {
  width: var(--other-width);
}

.hover-left .split.right:before {
  z-index: 2;
}

.hover-right .split.right {
  width: var(--hover-width);
}

.hover-right .split.left {
  width: var(--other-width);
}

.hover-right .split.left:before {
  z-index: 2;
}

@media (max-height: 700px) {
  .button {
    top: 70%;
  }
}

@media (max-width: 768px) {
  .center-logo img {
    max-width: 100px;
  }
}

  </style>
</head>
<body>
  <div class="container">
   
    <div class="split left">
      <h1>The Vendor</h1>
      <a href="#" class="button">Login</a>
    </div>
      <div class="center-logo">
    <img src="{{asset('assets/images/logo/3.png')}}" alt="Logo">
  </div>
    <div class="split right">
      <h1>The Driver</h1>
      <a href="#" class="button">Login</a>
    </div>
  </div>

  <script type="text/javascript" src="main.js"></script>
  <script>
    const left = document.querySelector(".left");
const right = document.querySelector(".right");
const container = document.querySelector(".container");

left.addEventListener("mouseenter", () => {
  container.classList.add("hover-left");
});

left.addEventListener("mouseleave", () => {
  container.classList.remove("hover-left");
});

right.addEventListener("mouseenter", () => {
  container.classList.add("hover-right");
});

right.addEventListener("mouseleave", () => {
  container.classList.remove("hover-right");
});

  </script>
</body>
</html>
